int led1 = 13;
short morseTable [26][5] = {
                           {1,2,0,0,0}, // A
                           {2,1,1,1,0}, // B
                           {2,1,2,1,0}, // C
                           {2,1,1,0,0}, // D
                           {1,0,0,0,0}, // E
                           {1,1,2,1,0}, // F
                           {2,2,1,0,0}, // G
                           {1,1,1,1,0}, // H
                           {1,1,0,0,0}, // I
                           {1,2,2,2,0}, // J
                           {2,1,2,0,0}, // K
                           {1,2,1,1,0}, // L
                           {2,2,0,0,0}, // M
                           {2,1,0,0,0}, // N
                           {2,2,2,0,0}, // O
                           {1,2,2,1,0}, // P
                           {2,2,1,2,0}, // Q
                           {1,2,1,0,0}, // R
                           {1,1,1,0,0}, // S
                           {2,0,0,0,0}, // T
                           {1,1,2,0,0}, // U
                           {1,1,1,2,0}, // V
                           {1,2,2,0,0}, // W
                           {2,1,1,2,0},  //X
                           {2,1,2,2,0},  //Y
                           {2,2,1,1,0}   //Z
                          }; 

void allumerLed(int temp){
   digitalWrite(led1, HIGH);
   delay(temp * 500); // chauqe unité représente 1/2 seconde
   digitalWrite(led1, LOW); 
}

void sendMorse(char c){
  int nbr;
  short i;
  nbr = c-65; //table Ascii
  if ((nbr >=0 ) && (nbr <=26)){
    for( i=0; i<5; i++){
       allumerLed(morseTable[nbr][i]);
       delay(500); //attendre 1/2 seconde entre chaque signale
    }
  } 
}

void setup(){
  Serial.begin(9600);
  pinMode(led1, OUTPUT);
  digitalWrite(led1, LOW);
}

void loop(){
  if(Serial.available() > 0){
    char c='\0';
    if (Serial.available()){
      delay(2);//Pour laisser le temps au buffer
      c =Serial.read();
      sendMorse(c);
    }
    Serial.print("Message envoye:");
    Serial.println(c);
  }
}
