/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.gray;

import com.cburch.gray.CounterData;
import com.cburch.gray.CounterPoker;
import com.cburch.gray.GrayIncrementer;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.net.URL;
import javax.swing.ImageIcon;

class GrayCounter
extends InstanceFactory {
    public static final String _ID = "Gray Counter";

    public GrayCounter() {
        super(_ID);
        this.setOffsetBounds(Bounds.create(-30, -15, 30, 30));
        this.setPorts(new Port[]{new Port(-30, 0, "input", 1), new Port(0, 0, "output", StdAttr.WIDTH)});
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.LABEL, StdAttr.LABEL_FONT}, new Object[]{BitWidth.create(4), "", StdAttr.DEFAULT_LABEL_FONT});
        this.setInstancePoker(CounterPoker.class);
        URL url = this.getClass().getClassLoader().getResource("com/cburch/gray/counter.gif");
        if (url != null) {
            this.setIcon(new ImageIcon(url));
        }
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 1);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.drawBounds();
        painter.drawClock(0, Direction.EAST);
        painter.drawPort(1);
        painter.drawLabel();
        if (painter.getShowState()) {
            BitWidth width = painter.getAttributeValue(StdAttr.WIDTH);
            CounterData state = CounterData.get(painter, width);
            Bounds bds = painter.getBounds();
            GraphicsUtil.drawCenteredText(painter.getGraphics(), StringUtil.toHexString(width.getWidth(), state.getValue().toLongValue()), bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        CounterData cur = CounterData.get(state, width);
        boolean trigger = cur.updateClock(state.getPortValue(0));
        if (trigger) {
            cur.setValue(GrayIncrementer.nextGray(cur.getValue()));
        }
        state.setPort(1, cur.getValue(), 9);
    }
}

