/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.gray;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;

class GrayIncrementer
extends InstanceFactory {
    public static final String _ID = "Gray Code Incrementer";

    GrayIncrementer() {
        super(_ID);
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create(4)});
        this.setOffsetBounds(Bounds.create(-30, -15, 30, 30));
        this.setPorts(new Port[]{new Port(-30, 0, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH)});
    }

    static Value nextGray(Value prev) {
        BitWidth bits = prev.getBitWidth();
        if (!prev.isFullyDefined()) {
            return Value.createError(bits);
        }
        long x = prev.toLongValue();
        long ct = x >> 32 ^ x;
        ct = ct >> 16 ^ ct;
        ct = ct >> 8 ^ ct;
        ct = ct >> 4 ^ ct;
        ct = ct >> 2 ^ ct;
        if (((ct = ct >> 1 ^ ct) & 1L) == 0L) {
            x ^= 1L;
        } else {
            long y = x ^ x & x - 1L;
            x = (y = y << 1 & bits.getMask()) == 0L ? 0L : x ^ y;
        }
        return Value.createKnown(bits, x);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.drawRectangle(painter.getBounds(), "G+1");
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value in = state.getPortValue(0);
        Value out = GrayIncrementer.nextGray(in);
        state.setPort(1, out, out.getWidth() + 1);
    }
}

