/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitTransactionResult;
import com.cburch.logisim.util.LineBuffer;

public record CircuitEvent(int getAction, Circuit getCircuit, Object getData) {
    public static final int ACTION_SET_NAME = 0;
    public static final int ACTION_ADD = 1;
    public static final int ACTION_REMOVE = 2;
    public static final int ACTION_INVALIDATE = 4;
    public static final int ACTION_CLEAR = 5;
    public static final int TRANSACTION_DONE = 6;
    public static final int CHANGE_DEFAULT_BOX_APPEARANCE = 7;
    public static final int ACTION_CHECK_NAME = 8;
    public static final int ACTION_DISPLAY_CHANGE = 9;

    public CircuitTransactionResult getResult() {
        return (CircuitTransactionResult)this.getData;
    }

    @Override
    public String toString() {
        String s = switch (this.getAction) {
            case 0 -> "ACTION_SET_NAME";
            case 1 -> "ACTION_ADD";
            case 2 -> "ACTION_REMOVE";
            case 4 -> "ACTION_INVALIDATE";
            case 5 -> "ACTION_CLEAR";
            case 6 -> "TRANSACTION_DONE";
            case 7 -> "DEFAULT_BOX_APPEARANCE";
            case 8 -> "CHECK_NAME";
            case 9 -> "ACTION_DISPLAY_CHANGE";
            default -> "UNKNOWN_ACTION(" + this.getAction + ")";
        };
        return LineBuffer.format("{{1}}{\n  circuit={{2}}\n  data={{3}}\n}", s, this.getCircuit, this.getData);
    }
}

