/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.gui.generic.ComboBox;
import com.cburch.logisim.util.StringGetter;
import java.awt.Component;

public class BitWidth
implements Comparable<BitWidth> {
    public static final BitWidth UNKNOWN = new BitWidth(0);
    public static final BitWidth ONE = new BitWidth(1);
    public static final int MAXWIDTH = 64;
    public static final int MINWIDTH = 1;
    private static BitWidth[] prefab = null;
    final int width;

    public static BitWidth create(int width) {
        BitWidth.ensurePrefab();
        if (width < 0) {
            throw new IllegalArgumentException("width " + width + " must be positive");
        }
        if (width >= prefab.length) {
            throw new IllegalArgumentException("width " + width + " must be at most 64");
        }
        return prefab[width];
    }

    private static void ensurePrefab() {
        if (prefab == null) {
            prefab = new BitWidth[65];
            BitWidth.prefab[0] = UNKNOWN;
            BitWidth.prefab[1] = ONE;
            for (int i = 2; i < prefab.length; ++i) {
                BitWidth.prefab[i] = new BitWidth(i);
            }
        }
    }

    public static BitWidth parse(String str) {
        if (str == null || str.length() == 0) {
            throw new NumberFormatException("Width string cannot be null");
        }
        if (str.charAt(0) == '/') {
            str = str.substring(1);
        }
        return BitWidth.create(Integer.parseInt(str));
    }

    private BitWidth(int width) {
        this.width = width;
    }

    @Override
    public int compareTo(BitWidth other) {
        return this.width - other.width;
    }

    public boolean equals(Object otherObj) {
        boolean bl;
        if (otherObj instanceof BitWidth) {
            BitWidth other = (BitWidth)otherObj;
            bl = this.width == other.width;
        } else {
            bl = false;
        }
        return bl;
    }

    public long getMask() {
        if (this.width == 0) {
            return 0L;
        }
        if (this.width == 64) {
            return -1L;
        }
        return (1L << this.width) - 1L;
    }

    public int getWidth() {
        return this.width;
    }

    public int hashCode() {
        return this.width;
    }

    public String toString() {
        return "" + this.width;
    }

    static class Attribute
    extends com.cburch.logisim.data.Attribute<BitWidth> {
        private final BitWidth[] choices;
        private final int min;
        private final int max;

        public Attribute(String name, StringGetter disp) {
            super(name, disp);
            this.min = 1;
            this.max = 64;
            int[] defaults = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 16, 24, 32, 64};
            this.choices = new BitWidth[defaults.length];
            for (int i = 0; i < defaults.length; ++i) {
                this.choices[i] = BitWidth.create(defaults[i]);
            }
        }

        public Attribute(String name, StringGetter disp, int min, int max) {
            super(name, disp);
            this.min = min;
            this.max = max;
            int length = max - min + 1;
            if (length > 12) {
                this.choices = null;
            } else {
                this.choices = new BitWidth[length];
                for (int i = 0; i < length; ++i) {
                    this.choices[i] = BitWidth.create(min + i);
                }
            }
        }

        @Override
        public Component getCellEditor(BitWidth value) {
            if (this.choices == null) {
                return super.getCellEditor(value);
            }
            ComboBox<BitWidth> combo = new ComboBox<BitWidth>((T[])this.choices);
            if (value != null) {
                combo.setSelectedItem(value);
            }
            combo.setEditable(true);
            return combo;
        }

        @Override
        public BitWidth parse(String value) {
            int v = (int)Long.parseLong(value);
            if (v < this.min) {
                throw new NumberFormatException("bit width must be at least " + this.min);
            }
            if (v > this.max) {
                throw new NumberFormatException("bit width must be at most " + this.max);
            }
            return BitWidth.create(v);
        }
    }
}

