/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryEventSource;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LoadedLibrary
extends Library
implements LibraryEventSource {
    private Library base;
    private boolean dirty = false;
    private final MyListener myListener = new MyListener();
    private final EventSourceWeakSupport<LibraryListener> listeners = new EventSourceWeakSupport();

    LoadedLibrary(Library base) {
        while (base instanceof LoadedLibrary) {
            LoadedLibrary lib = (LoadedLibrary)base;
            base = lib.base;
        }
        this.base = base;
        if (base instanceof LibraryEventSource) {
            LibraryEventSource src = (LibraryEventSource)((Object)base);
            src.addLibraryListener(this.myListener);
        }
    }

    static void copyAttributes(AttributeSet dest, AttributeSet src) {
        for (Attribute<?> destAttr : dest.getAttributes()) {
            Attribute<?> srcAttr = src.getAttribute(destAttr.getName());
            if (srcAttr == null) continue;
            Attribute<?> destAttr2 = destAttr;
            dest.setValue(destAttr2, src.getValue(srcAttr));
        }
    }

    private static AttributeSet createAttributes(ComponentFactory factory, AttributeSet src) {
        AttributeSet dest = factory.createAttributeSet();
        LoadedLibrary.copyAttributes(dest, src);
        return dest;
    }

    private static void replaceAll(Circuit circuit, Map<ComponentFactory, ComponentFactory> compMap) {
        ArrayList<Component> toReplace = null;
        for (Component comp : circuit.getNonWires()) {
            if (!compMap.containsKey(comp.getFactory())) continue;
            if (toReplace == null) {
                toReplace = new ArrayList<Component>();
            }
            toReplace.add(comp);
        }
        if (toReplace != null) {
            CircuitMutation xn = new CircuitMutation(circuit);
            for (Component comp : toReplace) {
                xn.remove(comp);
                ComponentFactory factory = compMap.get(comp.getFactory());
                if (factory == null) continue;
                AttributeSet newAttrs = LoadedLibrary.createAttributes(factory, comp.getAttributeSet());
                xn.add(factory.createComponent(comp.getLocation(), newAttrs));
            }
            xn.execute();
        }
    }

    private static void replaceAll(LogisimFile file, Map<ComponentFactory, ComponentFactory> compMap, Map<Tool, Tool> toolMap) {
        file.getOptions().getToolbarData().replaceAll(toolMap);
        file.getOptions().getMouseMappings().replaceAll(toolMap);
        for (Circuit circuit : file.getCircuits()) {
            LoadedLibrary.replaceAll(circuit, compMap);
        }
    }

    private static void replaceAll(Map<ComponentFactory, ComponentFactory> compMap, Map<Tool, Tool> toolMap) {
        for (Project proj : Projects.getOpenProjects()) {
            SubcircuitFactory oldFactory;
            Tool oldTool = proj.getTool();
            Circuit oldCircuit = proj.getCurrentCircuit();
            if (toolMap.containsKey(oldTool)) {
                proj.setTool(toolMap.get(oldTool));
            }
            if (compMap.containsKey(oldFactory = oldCircuit.getSubcircuitFactory())) {
                SubcircuitFactory newFactory = (SubcircuitFactory)compMap.get(oldFactory);
                proj.setCurrentCircuit(newFactory.getSubcircuit());
            }
            LoadedLibrary.replaceAll(proj.getLogisimFile(), compMap, toolMap);
        }
        for (LogisimFile file : LibraryManager.instance.getLogisimLibraries()) {
            LoadedLibrary.replaceAll(file, compMap, toolMap);
        }
    }

    @Override
    public void addLibraryListener(LibraryListener l) {
        this.listeners.add(l);
    }

    private void fireLibraryEvent(int action, Object data) {
        this.fireLibraryEvent(new LibraryEvent(this, action, data));
    }

    private void fireLibraryEvent(LibraryEvent event) {
        if (event.getSource() != this) {
            event = new LibraryEvent(this, event.getAction(), event.getData());
        }
        for (LibraryListener l : this.listeners) {
            l.libraryChanged(event);
        }
    }

    public Library getBase() {
        return this.base;
    }

    @Override
    public String getDisplayName() {
        return this.base.getDisplayName();
    }

    @Override
    public List<Library> getLibraries() {
        return this.base.getLibraries();
    }

    @Override
    public boolean removeLibrary(String name) {
        return this.base.removeLibrary(name);
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public List<? extends Tool> getTools() {
        return this.base.getTools();
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.base.isDirty();
    }

    @Override
    public void removeLibraryListener(LibraryListener l) {
        this.listeners.remove(l);
    }

    private void resolveChanges(Library old) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (!this.base.getDisplayName().equals(old.getDisplayName())) {
            this.fireLibraryEvent(6, this.base.getDisplayName());
        }
        HashSet<Library> changes = new HashSet<Library>(old.getLibraries());
        this.base.getLibraries().forEach(changes::remove);
        for (Library lib : changes) {
            this.fireLibraryEvent(4, lib);
        }
        changes.clear();
        changes.addAll(this.base.getLibraries());
        old.getLibraries().forEach(changes::remove);
        for (Library lib : changes) {
            this.fireLibraryEvent(3, lib);
        }
        HashMap<ComponentFactory, ComponentFactory> componentMap = new HashMap<ComponentFactory, ComponentFactory>();
        HashMap<Tool, Tool> toolMap = new HashMap<Tool, Tool>();
        for (Tool tool : old.getTools()) {
            Tool tool2 = this.base.getTool(tool.getName());
            toolMap.put(tool, tool2);
            if (!(tool instanceof AddTool)) continue;
            AddTool tool3 = (AddTool)tool;
            ComponentFactory oldFactory = tool3.getFactory();
            if (tool2 instanceof AddTool) {
                ComponentFactory newFactory = tool3.getFactory();
                componentMap.put(oldFactory, newFactory);
                continue;
            }
            componentMap.put(oldFactory, null);
        }
        LoadedLibrary.replaceAll(componentMap, toolMap);
        HashSet<? extends Tool> toolChanges = new HashSet<Tool>(old.getTools());
        toolChanges.removeAll(toolMap.keySet());
        for (Tool tool : toolChanges) {
            this.fireLibraryEvent(1, tool);
        }
        toolChanges = new HashSet<Tool>(this.base.getTools());
        toolChanges.removeAll(toolMap.values());
        for (Tool tool : toolChanges) {
            this.fireLibraryEvent(0, tool);
        }
    }

    void setBase(Library value) {
        Library library = this.base;
        if (library instanceof LibraryEventSource) {
            LibraryEventSource src = (LibraryEventSource)((Object)library);
            src.removeLibraryListener(this.myListener);
        }
        Library old = this.base;
        this.base = value;
        this.resolveChanges(old);
        Library library2 = this.base;
        if (library2 instanceof LibraryEventSource) {
            LibraryEventSource src = (LibraryEventSource)((Object)library2);
            src.addLibraryListener(this.myListener);
        }
    }

    void setDirty(boolean value) {
        if (this.dirty != value) {
            this.dirty = value;
            this.fireLibraryEvent(7, this.isDirty() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private class MyListener
    implements LibraryListener {
        private MyListener() {
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            LoadedLibrary.this.fireLibraryEvent(event);
        }
    }
}

