/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentsListener;
import com.cburch.logisim.fpga.data.MapListModel;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class IoComponentsInformation {
    private Frame parent;
    private final ArrayList<FpgaIoInformationContainer> ioComps;
    private int defaultStandard = 0;
    private int defaultDriveStrength = 0;
    private int defaultPullSelection = 0;
    private int defaultActivity = 1;
    private final boolean mapMode;
    private final int imageHeight;
    private final FpgaIoInformationContainer[][] lookup;
    private FpgaIoInformationContainer highlighted;
    private ArrayList<IoComponentsListener> listeners;

    public IoComponentsInformation(Frame parentFrame, boolean mapMode) {
        this.parent = parentFrame;
        this.imageHeight = mapMode ? 430 : 400;
        this.ioComps = new ArrayList();
        this.lookup = new FpgaIoInformationContainer[740][this.imageHeight];
        this.mapMode = mapMode;
        this.clear();
    }

    public void clear() {
        this.ioComps.clear();
        for (int x = 0; x < 740; ++x) {
            for (int y = 0; y < this.imageHeight; ++y) {
                this.lookup[x][y] = null;
            }
        }
        this.highlighted = null;
    }

    public Frame getParentFrame() {
        return this.parent;
    }

    public void setParentFrame(Frame parent) {
        this.parent = parent;
    }

    public boolean hasOverlap(BoardRectangle rect) {
        boolean overlap = false;
        for (FpgaIoInformationContainer io : this.ioComps) {
            overlap |= io.getRectangle().overlap(rect).booleanValue();
        }
        return overlap;
    }

    public boolean hasOverlap(BoardRectangle orig, BoardRectangle update) {
        boolean overlap = false;
        for (FpgaIoInformationContainer io : this.ioComps) {
            if (io.getRectangle().equals(orig)) continue;
            overlap |= io.getRectangle().overlap(update).booleanValue();
        }
        return overlap;
    }

    public boolean hasComponents() {
        return !this.ioComps.isEmpty();
    }

    public List<FpgaIoInformationContainer> getComponents() {
        return this.ioComps;
    }

    public boolean hasHighlighted() {
        return this.highlighted != null;
    }

    public FpgaIoInformationContainer getHighligted() {
        return this.highlighted;
    }

    public boolean tryMap(JPanel parent) {
        if (!this.mapMode) {
            return false;
        }
        if (this.highlighted != null) {
            return this.highlighted.tryMap(parent);
        }
        return false;
    }

    public void setSelectable(MapListModel.MapInfo comp, float scale) {
        for (FpgaIoInformationContainer io : this.ioComps) {
            if (!io.setSelectable(comp)) continue;
            this.fireRedraw(io.getRectangle(), scale);
        }
    }

    public void removeSelectable(float scale) {
        for (FpgaIoInformationContainer io : this.ioComps) {
            if (!io.removeSelectable()) continue;
            this.fireRedraw(io.getRectangle(), scale);
        }
    }

    public void addComponent(FpgaIoInformationContainer comp, float scale) {
        if (!this.ioComps.contains(comp)) {
            this.ioComps.add(comp);
            BoardRectangle rect = comp.getRectangle();
            for (int x = rect.getXpos(); x < rect.getXpos() + rect.getWidth(); ++x) {
                for (int y = rect.getYpos(); y < rect.getYpos() + rect.getHeight(); ++y) {
                    if (x >= 740 || y >= this.imageHeight) continue;
                    this.lookup[x][y] = comp;
                }
            }
            if (this.mapMode) {
                return;
            }
            this.fireRedraw(comp.getRectangle(), scale);
        }
    }

    public void removeComponent(FpgaIoInformationContainer comp, float scale) {
        if (this.ioComps.contains(comp)) {
            if (this.highlighted == comp) {
                this.highlighted = null;
            }
            this.ioComps.remove(comp);
            BoardRectangle rect = comp.getRectangle();
            for (int x = rect.getXpos(); x < rect.getXpos() + rect.getWidth(); ++x) {
                for (int y = rect.getYpos(); y < rect.getYpos() + rect.getHeight(); ++y) {
                    this.lookup[x][y] = null;
                }
            }
            this.fireRedraw(comp.getRectangle(), scale);
        }
    }

    public void replaceComponent(FpgaIoInformationContainer oldI, FpgaIoInformationContainer newI, MouseEvent e, float scale) {
        if (!this.ioComps.contains(oldI)) {
            return;
        }
        this.removeComponent(oldI, scale);
        this.addComponent(newI, scale);
        this.mouseMoved(e, scale);
    }

    public void mouseMoved(MouseEvent e, float scale) {
        int xpos = AppPreferences.getDownScaled(e.getX(), scale);
        int ypos = AppPreferences.getDownScaled(e.getY(), scale);
        xpos = Math.max(xpos, 0);
        xpos = Math.min(xpos, 739);
        ypos = Math.max(ypos, 0);
        FpgaIoInformationContainer selected = this.lookup[xpos][ypos = Math.min(ypos, this.imageHeight - 1)];
        if (selected == this.highlighted) {
            if (this.highlighted != null && this.highlighted.selectedPinChanged(xpos, ypos)) {
                this.fireRedraw(this.highlighted.getRectangle(), scale);
            }
            return;
        }
        if (this.highlighted != null) {
            this.highlighted.unsetHighlighted();
            this.fireRedraw(this.highlighted.getRectangle(), scale);
        }
        if (selected != null) {
            selected.setHighlighted();
            this.fireRedraw(selected.getRectangle(), scale);
        }
        this.highlighted = selected;
    }

    public void mouseExited(float scale) {
        if (this.highlighted != null) {
            this.highlighted.unsetHighlighted();
            this.fireRedraw(this.highlighted.getRectangle(), scale);
            this.highlighted = null;
        }
    }

    public void addListener(IoComponentsListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            this.listeners.add(l);
        } else if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(IoComponentsListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public int getDefaultActivity() {
        return this.defaultActivity;
    }

    public int getDefaultDriveStrength() {
        return this.defaultDriveStrength;
    }

    public int getDefaultPullSelection() {
        return this.defaultPullSelection;
    }

    public int getDefaultStandard() {
        return this.defaultStandard;
    }

    public void setDefaultActivity(int value) {
        this.defaultActivity = value;
    }

    public void setDefaultDriveStrength(int value) {
        this.defaultDriveStrength = value;
    }

    public void setDefaultPullSelection(int value) {
        this.defaultPullSelection = value;
    }

    public void setDefaultStandard(int value) {
        this.defaultStandard = value;
    }

    public void paint(Graphics2D g, float scale) {
        for (FpgaIoInformationContainer c : this.ioComps) {
            c.paint(g, scale);
        }
    }

    private void fireRedraw(BoardRectangle rect, float scale) {
        if (this.listeners == null) {
            return;
        }
        Rectangle area = new Rectangle(AppPreferences.getScaled(rect.getXpos() - 2, scale), AppPreferences.getScaled(rect.getYpos() - 2, scale), AppPreferences.getScaled(rect.getWidth() + 4, scale), AppPreferences.getScaled(rect.getHeight() + 4, scale));
        for (IoComponentsListener l : this.listeners) {
            l.repaintRequest(area);
        }
    }
}

