/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.data.MapComponent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultListModel;

public class MapListModel
extends DefaultListModel<MapInfo> {
    private static final long serialVersionUID = 1L;
    private boolean mappedList = false;
    private final Map<ArrayList<String>, MapComponent> myMappableResources;
    private ArrayList<MapInfo> myItems;

    public MapListModel(boolean mappedList, Map<ArrayList<String>, MapComponent> myMappableResources) {
        this.mappedList = mappedList;
        this.myMappableResources = myMappableResources;
        this.rebuild();
    }

    public void rebuild() {
        int oldsize = 0;
        if (this.myItems == null) {
            this.myItems = new ArrayList();
        } else {
            oldsize = this.myItems.size();
            this.myItems.clear();
        }
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            int i;
            int idx;
            MapComponent map = this.myMappableResources.get(key);
            if (this.mappedList) {
                if (map.isCompleteMap(false)) {
                    idx = this.getInsertionPoint(map);
                    this.myItems.add(idx, new MapInfo(map.getNrOfPins() == 1 ? 0 : -1, map));
                    continue;
                }
                idx = this.getInsertionPoint(map);
                for (i = map.getNrOfPins() - 1; i >= 0; --i) {
                    if (!map.isMapped(i)) continue;
                    this.myItems.add(idx, new MapInfo(i, map));
                }
                continue;
            }
            if (map.isNotMapped()) {
                idx = this.getInsertionPoint(map);
                this.myItems.add(idx, new MapInfo(map.getNrOfPins() == 1 ? 0 : -1, map));
                continue;
            }
            idx = this.getInsertionPoint(map);
            for (i = map.getNrOfPins() - 1; i >= 0; --i) {
                if (map.isMapped(i)) continue;
                this.myItems.add(idx, new MapInfo(i, map));
            }
        }
        if (oldsize > 0 || !this.myItems.isEmpty()) {
            this.fireContentsChanged(this, 0, Math.max(oldsize, this.myItems.size()));
        }
    }

    private int getInsertionPoint(MapComponent map) {
        int idx;
        if (this.myItems.isEmpty()) {
            return 0;
        }
        for (idx = 0; idx < this.myItems.size() && this.myItems.get(idx).getMap().getDisplayString(-1).compareToIgnoreCase(map.getDisplayString(-1)) < 0; ++idx) {
        }
        return idx;
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    @Override
    public int size() {
        return this.myItems.size();
    }

    @Override
    public MapInfo elementAt(int idx) {
        if (idx < 0 || idx >= this.myItems.size()) {
            return null;
        }
        return this.myItems.get(idx);
    }

    @Override
    public MapInfo getElementAt(int idx) {
        return this.elementAt(idx);
    }

    public static class MapInfo {
        private final int pinNr;
        private final MapComponent map;

        public MapInfo(int pin, MapComponent map) {
            this.pinNr = pin;
            this.map = map;
        }

        public int getPin() {
            return this.pinNr;
        }

        public MapComponent getMap() {
            return this.map;
        }

        public String toString() {
            return this.map.getDisplayString(this.pinNr);
        }
    }
}

