/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.test;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.TestVector;
import com.cburch.logisim.gui.test.ModelListener;
import com.cburch.logisim.gui.test.TestThread;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

class Model {
    private final EventSourceWeakSupport<ModelListener> listeners;
    private final Project project;
    private final Circuit circuit;
    private final UpdateResultSort myUpdateResultSort = new UpdateResultSort();
    private final ArrayList<Integer> failed = new ArrayList();
    private final ArrayList<Integer> passed = new ArrayList();
    private boolean selected = false;
    private boolean running;
    private boolean paused;
    private TestThread tester;
    private int numPass = 0;
    private int numFail = 0;
    private TestVector vec = null;
    private TestException[] results;

    public Model(Project proj, Circuit circuit) {
        this.listeners = new EventSourceWeakSupport();
        this.circuit = circuit;
        this.project = proj;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResults() {
        this.stop();
        Model model = this;
        synchronized (model) {
            if (this.vec == null || this.results == null) {
                return;
            }
            this.numFail = 0;
            this.numPass = 0;
            this.failed.clear();
            this.passed.clear();
        }
        this.fireTestResultsChanged();
    }

    private void fireTestingChanged() {
        for (ModelListener listener : this.listeners) {
            listener.testingChanged();
        }
    }

    private void fireTestResultsChanged() {
        for (ModelListener listener : this.listeners) {
            listener.testResultsChanged(this.numPass, this.numFail);
        }
    }

    private void fireVectorChanged() {
        for (ModelListener listener : this.listeners) {
            listener.vectorChanged();
        }
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public int getFail() {
        return this.numFail;
    }

    public int getPass() {
        return this.numPass;
    }

    public Project getProject() {
        return this.project;
    }

    public TestException[] getResults() {
        return this.results;
    }

    public TestVector getVector() {
        return this.vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setVector(TestVector v) {
        this.stop();
        Model model = this;
        synchronized (model) {
            this.vec = v;
            this.results = v != null ? new TestException[v.data.size()] : null;
            this.numFail = 0;
            this.numPass = 0;
            this.failed.clear();
            this.passed.clear();
        }
        this.fireVectorChanged();
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        Model model = this;
        synchronized (model) {
            if (this.running && this.tester != null) {
                this.tester.setPaused(paused);
            }
            this.paused = paused;
        }
        this.fireTestingChanged();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        if (this.selected == value) {
            return;
        }
        this.selected = value;
        this.setPaused(!this.selected);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setResult(TestVector v, int idx, TestException err) {
        Model model = this;
        synchronized (model) {
            if (v != this.vec || idx < 0 || idx >= this.results.length || idx != this.numPass + this.numFail) {
                return false;
            }
            this.results[idx] = err;
            if (err == null) {
                ++this.numPass;
            } else {
                ++this.numFail;
            }
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this.myUpdateResultSort);
        } else {
            this.updateResultSort();
        }
        return true;
    }

    public int sortedIndex(int i) {
        if (i < this.failed.size()) {
            return this.failed.get(i);
        }
        if (i < this.failed.size() + this.passed.size()) {
            return this.passed.get(i - this.failed.size());
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws TestException {
        Model model = this;
        synchronized (model) {
            if (this.vec == null) {
                return;
            }
            if (this.running) {
                this.setPaused(false);
                return;
            }
            this.tester = new TestThread(this);
            this.running = true;
            this.paused = false;
            this.tester.start();
        }
        this.fireTestingChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Model model = this;
        synchronized (model) {
            if (!this.running) {
                return;
            }
            this.running = false;
            if (this.tester != null) {
                this.tester.cancel();
            }
            this.tester = null;
        }
        this.fireTestingChanged();
    }

    private void updateResultSort() {
        if (this.vec == null) {
            return;
        }
        for (int i = this.failed.size() + this.passed.size(); i < this.numPass + this.numFail; ++i) {
            if (this.results[i] == null) {
                this.passed.add(i);
                continue;
            }
            this.failed.add(i);
        }
        this.fireTestResultsChanged();
    }

    private class UpdateResultSort
    implements Runnable {
        private UpdateResultSort() {
        }

        @Override
        public void run() {
            Model.this.updateResultSort();
        }
    }
}

