/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.std.hdl.DenseLogicCircuit;
import com.cburch.logisim.std.hdl.DenseLogicCircuitBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class BlifParser {
    public static final String RECOMMENDED_LOGIC_LIBRARY_URL = "https://github.com/YosysHQ/yosys/tree/main/examples/cmos";
    private final List<HdlModel.PortDescription> inputs;
    private final List<HdlModel.PortDescription> outputs;
    private final List<Gate> gates;
    private final List<Mux> muxes;
    private final List<Dff> dff;
    private final List<Dffsr> dffsr;
    private final List<Latch> latches;
    private final List<String> pullups;
    private final List<String> pulldowns;
    private final String source;
    private String name;

    public BlifParser(String source) {
        this.source = source;
        this.inputs = new ArrayList<HdlModel.PortDescription>();
        this.outputs = new ArrayList<HdlModel.PortDescription>();
        this.gates = new ArrayList<Gate>();
        this.muxes = new ArrayList<Mux>();
        this.dff = new ArrayList<Dff>();
        this.dffsr = new ArrayList<Dffsr>();
        this.latches = new ArrayList<Latch>();
        this.pullups = new ArrayList<String>();
        this.pulldowns = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void parse() {
        TreeSet<String> inputSet = new TreeSet<String>();
        TreeSet<String> outputSet = new TreeSet<String>();
        for (String s2 : this.source.split("\n")) {
            String d;
            String y;
            String lineActual = s2.trim();
            if (!lineActual.startsWith(".")) continue;
            String[] words = lineActual.split(" ");
            if (words[0].equals(".inputs")) {
                for (int i = 1; i < words.length; ++i) {
                    inputSet.add(words[i]);
                }
                continue;
            }
            if (words[0].equals(".outputs")) {
                for (int i = 1; i < words.length; ++i) {
                    outputSet.add(words[i]);
                }
                continue;
            }
            if (words[0].equals(".model")) {
                if (words.length <= 1) continue;
                if (this.name != null) {
                    throw new RuntimeException("many tops (try 'synth -flatten -top " + this.name + "')");
                }
                this.name = words[1];
                continue;
            }
            if (words[0].equals(".names")) {
                if (words.length == 2) {
                    if (words[1].equals("$true") || words[1].equals("$false") || words[1].equals("$undef")) continue;
                    throw new RuntimeException("odd .names (try 'write_blif -icells -conn out.blif')");
                }
                throw new RuntimeException("odd .names (try 'write_blif -icells -conn out.blif')");
            }
            if (words[0].equals(".conn")) {
                this.gates.add(new Gate(0, words[1], words[1], words[2]));
                continue;
            }
            if (!words[0].equals(".subckt") && !words[0].equals(".gate")) continue;
            String type = words[1];
            HashMap<String, String> pins = new HashMap<String, String>();
            for (int i = 2; i < words.length; ++i) {
                String assignment = words[i];
                int eq = assignment.indexOf(61);
                String k = assignment.substring(0, eq);
                String v = assignment.substring(eq + 1);
                pins.put(k, v);
            }
            if (type.equals("BUF")) {
                String a = (String)pins.get("A");
                y = (String)pins.get("Y");
                this.gates.add(new Gate(0, a, a, y));
                continue;
            }
            if (type.equals("NOT")) {
                String a = (String)pins.get("A");
                y = (String)pins.get("Y");
                this.gates.add(new Gate(7, a, a, y));
                continue;
            }
            if (type.equals("MUX")) {
                String a = (String)pins.get("A");
                String b = (String)pins.get("B");
                String select = (String)pins.get("S");
                String y2 = (String)pins.get("Y");
                this.muxes.add(new Mux(a, b, select, y2));
                continue;
            }
            if (type.equals("PULLUP")) {
                this.pullups.add((String)pins.get("Y"));
                continue;
            }
            if (type.equals("PULLDOWN")) {
                this.pulldowns.add((String)pins.get("Y"));
                continue;
            }
            if (type.equals("DFF")) {
                String c = (String)pins.get("C");
                d = (String)pins.get("D");
                String q = (String)pins.get("Q");
                this.dff.add(new Dff(c, d, q));
                continue;
            }
            if (type.equals("DFFSR")) {
                String c = (String)pins.get("C");
                d = (String)pins.get("D");
                String q = (String)pins.get("Q");
                this.dffsr.add(new Dffsr(c, d, q, (String)pins.get("S"), (String)pins.get("R")));
                continue;
            }
            if (type.equals("DLATCH")) {
                String d2 = (String)pins.get("D");
                String e = (String)pins.get("E");
                String q = (String)pins.get("Q");
                this.latches.add(new Latch(d2, e, q));
                continue;
            }
            boolean found = false;
            String[] gateTypeNames = DenseLogicCircuit.GATE_TYPE_NAMES;
            for (int gateType = 0; gateType < gateTypeNames.length; ++gateType) {
                if (!type.equals(gateTypeNames[gateType])) continue;
                this.gates.add(new Gate(gateType, (String)pins.get("A"), (String)pins.get("B"), (String)pins.get("Y")));
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("unknown gate " + type + "\ntry basing your script on https://github.com/YosysHQ/yosys/tree/main/examples/cmos");
        }
        inputSet.removeIf(s -> outputSet.contains(s));
        this.parseNameSet(this.inputs, inputSet, "input");
        this.parseNameSet(this.outputs, outputSet, "output");
    }

    private void parseNameSet(List<HdlModel.PortDescription> ports, SortedSet<String> src, String type) {
        TreeMap<String, Integer> maxBitNumbers = new TreeMap<String, Integer>();
        while (!src.isEmpty()) {
            int leftIdx;
            String queue = src.removeFirst();
            if (queue.endsWith("]") && (leftIdx = queue.lastIndexOf(91)) != -1) {
                String bitIndex = queue.substring(leftIdx + 1, queue.length() - 1);
                try {
                    int num = Integer.parseUnsignedInt(bitIndex);
                    String prefix = queue.substring(0, leftIdx);
                    Integer existing = (Integer)maxBitNumbers.get(prefix);
                    if (existing != null && existing > num) {
                        num = existing;
                    }
                    maxBitNumbers.put(prefix, num);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ports.add(new HdlModel.PortDescription(queue, type, 1));
        }
        for (Map.Entry map : maxBitNumbers.entrySet()) {
            int width = (Integer)map.getValue() + 1;
            if (width == 1) {
                ports.add(new HdlModel.PortDescription((String)map.getKey() + "[0]", type, 1));
                continue;
            }
            ports.add(new HdlModel.PortDescription((String)map.getKey(), type, width));
        }
    }

    public String getPinBlifSymbol(HdlModel.PortDescription port, int index) {
        int width = port.getWidthInt();
        if (width == 1) {
            return port.getName();
        }
        return port.getName() + "[" + index + "]";
    }

    public String getPinDlcSymbol(HdlModel.PortDescription port, int index, boolean output) {
        return (output ? "o." : "x.") + this.getPinBlifSymbol(port, index);
    }

    public List<HdlModel.PortDescription> getInputs() {
        return this.inputs;
    }

    public List<HdlModel.PortDescription> getOutputs() {
        return this.outputs;
    }

    public DenseLogicCircuit compile() {
        int q;
        int d;
        int c;
        int b;
        int a;
        DenseLogicCircuitBuilder builder = new DenseLogicCircuitBuilder();
        builder.symbolTable.put("i.$false", 1);
        builder.symbolTable.put("o.$false", 1);
        builder.symbolTable.put("i.$true", 2);
        builder.symbolTable.put("o.$true", 2);
        builder.symbolTable.put("i.$undef", 0);
        builder.symbolTable.put("o.$undef", 0);
        for (HdlModel.PortDescription portDescription : this.inputs) {
            this.compilePort(builder, portDescription);
        }
        for (HdlModel.PortDescription portDescription : this.outputs) {
            this.compilePort(builder, portDescription);
        }
        for (Gate gate : this.gates) {
            a = this.compileGetInput(builder, gate.a);
            b = this.compileGetInput(builder, gate.b);
            int y = this.compileGetOutput(builder, gate.y);
            builder.attachGate(gate.type, a, b, y);
        }
        for (Mux mux : this.muxes) {
            a = this.compileGetInput(builder, mux.a);
            b = this.compileGetInput(builder, mux.b);
            int s = this.compileGetInput(builder, mux.s);
            int y = this.compileGetOutput(builder, mux.y);
            builder.attachGate(2, a, s, y);
            builder.attachGate(1, b, s, y);
        }
        for (Dff dff : this.dff) {
            c = this.compileGetInput(builder, dff.c);
            d = this.compileGetInput(builder, dff.d);
            q = this.compileGetOutput(builder, dff.q);
            builder.attachBuffer(builder.addDff(c, d), q);
        }
        for (Latch latch : this.latches) {
            int d2 = this.compileGetInput(builder, latch.d);
            int e = this.compileGetInput(builder, latch.e);
            q = this.compileGetOutput(builder, latch.q);
            builder.attachBuffer(builder.addLatch(d2, e), q);
        }
        for (Dffsr dffsr : this.dffsr) {
            c = this.compileGetInput(builder, dffsr.c);
            d = this.compileGetInput(builder, dffsr.d);
            q = this.compileGetOutput(builder, dffsr.q);
            int s = this.compileGetInput(builder, dffsr.s);
            int r = this.compileGetInput(builder, dffsr.r);
            builder.attachBuffer(builder.addDffsr(c, d, s, r), q);
        }
        for (String string : this.pullups) {
            builder.setCellPull(this.compileGetOutput(builder, string), 2);
        }
        for (String string : this.pulldowns) {
            builder.setCellPull(this.compileGetOutput(builder, string), 1);
        }
        return builder.build();
    }

    private void compileBidiPin(DenseLogicCircuitBuilder builder, String pin) {
        int externalInput = builder.addCell(true);
        int internalInput = builder.addCell(false);
        int externalOutput = builder.addCell(false);
        builder.symbolTable.put("x." + pin, externalInput);
        builder.symbolTable.put("i." + pin, internalInput);
        builder.symbolTable.put("o." + pin, externalOutput);
        builder.attachGate(0, externalInput, externalOutput, internalInput);
    }

    private void compilePort(DenseLogicCircuitBuilder builder, HdlModel.PortDescription port) {
        int width = port.getWidthInt();
        for (int i = 0; i < width; ++i) {
            this.compileBidiPin(builder, this.getPinBlifSymbol(port, i));
        }
    }

    private int compileGetInput(DenseLogicCircuitBuilder builder, String pin) {
        Integer existing = builder.symbolTable.get("i." + pin);
        if (existing == null) {
            existing = this.compileNewWire(builder, pin);
        }
        return existing;
    }

    private int compileGetOutput(DenseLogicCircuitBuilder builder, String pin) {
        Integer existing = builder.symbolTable.get("o." + pin);
        if (existing == null) {
            existing = this.compileNewWire(builder, pin);
        }
        return existing;
    }

    private int compileNewWire(DenseLogicCircuitBuilder builder, String pin) {
        int res = builder.addCell(false);
        builder.symbolTable.put("i." + pin, res);
        builder.symbolTable.put("o." + pin, res);
        return res;
    }

    private record Gate(int type, String a, String b, String y) {
    }

    private record Mux(String a, String b, String s, String y) {
    }

    private record Dff(String c, String d, String q) {
    }

    private record Dffsr(String c, String d, String q, String s, String r) {
    }

    private record Latch(String d, String e, String q) {
    }
}

