/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.gui.icons.FlipFlopIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.RegisterData;
import com.cburch.logisim.std.memory.RegisterHdlGeneratorFactory;
import com.cburch.logisim.std.memory.RegisterLogger;
import com.cburch.logisim.std.memory.RegisterPoker;
import com.cburch.logisim.std.memory.RegisterShape;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Register
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "Register";
    static final int DELAY = 8;
    public static final int OUT = 0;
    public static final int IN = 1;
    public static final int CK = 2;
    public static final int CLR = 3;
    public static final int EN = 4;
    static final int Xsize = 60;
    static final int Ysize = 90;
    public static final Attribute<Boolean> ATTR_SHOW_IN_TAB = Attributes.forBoolean("showInTab", Strings.S.getter("registerShowInTab"));

    public static void drawRegisterClassic(InstancePainter painter, int x, int y, int nr_of_bits, boolean isLatch, boolean neg_active, boolean has_we, String value) {
    }

    public static void drawRegisterEvolution(InstancePainter painter, int x, int y, int nrOfBits, boolean isLatch, boolean negActive, boolean hasWE, Value value) {
        int dq_widtdqWidth = nrOfBits == 1 ? 2 : 5;
        int len = (nrOfBits + 3) / 4;
        int wid = 8 * len + 2;
        int xoff = (60 - wid) / 2;
        Graphics g = painter.getGraphics();
        if (painter.getShowState() && value != null) {
            if (value.isFullyDefined()) {
                g.setColor(Color.LIGHT_GRAY);
            } else if (value.isErrorValue()) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            g.fillRect(x + xoff, y + 1, wid, 16);
            if (value.isFullyDefined()) {
                g.setColor(Color.DARK_GRAY);
            } else {
                g.setColor(Color.YELLOW);
            }
            String str = "";
            if (value.isFullyDefined()) {
                str = StringUtil.toHexString(nrOfBits, value.toLongValue());
            } else {
                for (int i = 0; i < len; ++i) {
                    str = str.concat("?");
                }
            }
            GraphicsUtil.drawCenteredText(g, str, x + 30, y + 8);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        GraphicsUtil.switchToWidth(g, 2);
        if (nrOfBits > 1) {
            g.drawLine(x + 15, y + 80, x + 15, y + 85);
            g.drawLine(x + 15, y + 85, x + 55, y + 85);
            g.drawLine(x + 55, y + 25, x + 55, y + 85);
            g.drawLine(x + 50, y + 25, x + 55, y + 25);
            if (nrOfBits > 2) {
                g.drawLine(x + 20, y + 85, x + 20, y + 90);
                g.drawLine(x + 20, y + 90, x + 60, y + 90);
                g.drawLine(x + 60, y + 30, x + 60, y + 90);
                g.drawLine(x + 55, y + 30, x + 60, y + 30);
            }
            g.setColor(Value.multiColor);
        }
        GraphicsUtil.switchToWidth(g, dq_widtdqWidth);
        g.drawLine(x, y + 30, x + 8, y + 30);
        g.drawLine(x + 52, y + 30, x + 60, y + 30);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(x + 10, y + 20, 40, 60);
        GraphicsUtil.switchToWidth(g, 1);
        GraphicsUtil.drawCenteredText(g, "D", x + 18, y + 28);
        GraphicsUtil.drawCenteredText(g, "Q", x + 41, y + 28);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawLine(x + 30, y + 81, x + 30, y + 90);
        GraphicsUtil.switchToWidth(g, 1);
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        GraphicsUtil.drawCenteredText(g, "R", x + 30, y + 68);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        if (hasWE) {
            GraphicsUtil.drawCenteredText(g, "WE", x + 22, y + 48);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawLine(x, y + 50, x + 9, y + 50);
            GraphicsUtil.switchToWidth(g, 1);
        }
        if (!isLatch) {
            painter.drawClockSymbol(x + 10, y + 70);
        } else {
            GraphicsUtil.drawCenteredText(g, "E", x + 18, y + 68);
        }
        if (!negActive) {
            GraphicsUtil.switchToWidth(g, 2);
            g.drawLine(x, y + 70, x + 9, y + 70);
        } else {
            GraphicsUtil.switchToWidth(g, 2);
            g.drawOval(x, y + 65, 10, 10);
        }
        GraphicsUtil.switchToWidth(g, 1);
    }

    public void drawRegisterClassic(InstancePainter painter) {
        String a;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        RegisterData state = (RegisterData)painter.getData();
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        String b = null;
        if (painter.getShowState()) {
            long val = state == null ? 0L : state.value.toLongValue();
            String str = StringUtil.toHexString(width, val);
            if (str.length() <= 4) {
                a = str;
            } else {
                int split = str.length() - 4;
                a = str.substring(0, split);
                b = str.substring(split);
            }
        } else {
            a = Strings.S.get("registerLabel");
            b = Strings.S.get("registerWidthLabel", "" + widthVal.getWidth());
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        g.setColor(painter.getAttributeValue(StdAttr.LABEL_COLOR));
        painter.drawLabel();
        if (b == null) {
            painter.drawPort(1, "D", Direction.EAST);
            painter.drawPort(0, "Q", Direction.WEST);
        } else {
            painter.drawPort(1);
            painter.drawPort(0);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(3, "0", Direction.SOUTH);
        painter.drawPort(4, Strings.S.get("memEnableLabel"), Direction.EAST);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawClock(2, Direction.NORTH);
        if (b == null) {
            GraphicsUtil.drawText(g, a, bds.getX() + 15, bds.getY() + 4, 0, -1);
        } else {
            GraphicsUtil.drawText(g, a, bds.getX() + 15, bds.getY() + 3, 0, -1);
            GraphicsUtil.drawText(g, b, bds.getX() + 15, bds.getY() + 15, 0, -1);
        }
    }

    public Register() {
        super(_ID, Strings.S.getter("registerComponent"), new RegisterHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.TRIGGER, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, ATTR_SHOW_IN_TAB, StdAttr.APPEARANCE}, new Object[]{BitWidth.create(8), StdAttr.TRIG_RISING, "", Direction.NORTH, StdAttr.DEFAULT_LABEL_FONT, false, AppPreferences.getDefaultAppearance()});
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(StdAttr.WIDTH), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        this.setIcon(new FlipFlopIcon(4));
        this.setInstancePoker(RegisterPoker.class);
        this.setInstanceLogger(RegisterLogger.class);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        if (attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            return Bounds.create(-30, -20, 30, 40);
        }
        return Bounds.create(0, 0, 60, 90);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        instance.computeLabelTextField(10);
    }

    private void updatePorts(Instance instance) {
        Port[] ps = new Port[5];
        if (instance.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            ps[0] = new Port(0, 0, "output", StdAttr.WIDTH);
            ps[1] = new Port(-30, 0, "input", StdAttr.WIDTH);
            ps[2] = new Port(-20, 20, "input", 1);
            ps[3] = new Port(-10, 20, "input", 1);
            ps[4] = new Port(-30, 10, "input", 1);
        } else {
            ps[0] = new Port(60, 30, "output", StdAttr.WIDTH);
            ps[1] = new Port(0, 30, "input", StdAttr.WIDTH);
            ps[2] = new Port(0, 70, "input", 1);
            ps[3] = new Port(30, 90, "input", 1);
            ps[4] = new Port(0, 50, "input", 1);
        }
        ps[0].setToolTip(Strings.S.getter("registerQTip"));
        ps[1].setToolTip(Strings.S.getter("registerDTip"));
        ps[2].setToolTip(Strings.S.getter("registerClkTip"));
        ps[3].setToolTip(Strings.S.getter("registerClrTip"));
        ps[4].setToolTip(Strings.S.getter("registerEnableTip"));
        instance.setPorts(ps);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder CompleteName = new StringBuilder();
        CompleteName.append(CorrectLabel.getCorrectLabel(this.getName()).toUpperCase());
        if (attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_FALLING || attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_RISING) {
            CompleteName.append("_FLIP_FLOP");
        } else {
            CompleteName.append("_LATCH");
        }
        return CompleteName.toString();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            this.drawRegisterClassic(painter);
        } else {
            RegisterData state = (RegisterData)painter.getData();
            BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
            int width = widthVal == null ? 8 : widthVal.getWidth();
            Location loc = painter.getLocation();
            int x = loc.getX();
            int y = loc.getY();
            AttributeOption Trigger = painter.getAttributeValue(StdAttr.TRIGGER);
            boolean IsLatch = Trigger.equals(StdAttr.TRIG_HIGH) || Trigger.equals(StdAttr.TRIG_LOW);
            boolean NegActive = Trigger.equals(StdAttr.TRIG_FALLING) || Trigger.equals(StdAttr.TRIG_LOW);
            Register.drawRegisterEvolution(painter, x, y, width, IsLatch, NegActive, true, state == null ? null : state.value);
            painter.drawLabel();
            painter.drawPort(1);
            painter.drawPort(0);
            painter.drawPort(3);
            painter.drawPort(4);
            painter.drawPort(2);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        AttributeOption triggerType = state.getAttributeValue(StdAttr.TRIGGER);
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData(dataWidth);
            state.setData(data);
        }
        boolean triggered = data.updateClock(state.getPortValue(2), triggerType);
        if (state.getPortValue(3) == Value.TRUE) {
            data.value = Value.createKnown(dataWidth, 0L);
        } else if (triggered && state.getPortValue(4) != Value.FALSE) {
            data.value = state.getPortValue(1);
        }
        state.setPort(0, data.value, 8);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return Netlist.isFlipFlop(comp.getComponent().getAttributeSet());
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{2};
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.WIDTH || attr == StdAttr.APPEARANCE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(10);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(10);
        }
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new RegisterShape(x, y, path);
    }
}

