/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.util.LineBuffer;

public class DemultiplexerHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;

    public DemultiplexerHdlGeneratorFactory() {
        this.myParametersList.addBusOnly(NR_OF_BITS_STRING, -1);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        int nrOfSelectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth() == 1 ? 1 : -1;
        int selectInputIndex = 1 << nrOfSelectBits;
        Boolean hasenable = attrs.getValue(PlexersLibrary.ATTR_ENABLE);
        for (int outp = 0; outp < selectInputIndex; ++outp) {
            this.myPorts.add("output", String.format("demuxOut_%d", outp), nrOfBits, outp, StdAttr.WIDTH);
        }
        this.myPorts.add("input", "sel", nrOfSelectBits, selectInputIndex).add("input", "demuxIn", nrOfBits, hasenable != false ? selectInputIndex + 2 : selectInputIndex + 1);
        if (hasenable.booleanValue()) {
            this.myPorts.add("input", "enable", 1, selectInputIndex + 1, false);
        } else {
            this.myPorts.add("input", "enable", 1, Hdl.oneBit());
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetList, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        String space = "  ";
        int nrOfSelectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int numOutputs = 1 << nrOfSelectBits;
        for (int i = 0; i < numOutputs; ++i) {
            if (i == 10) {
                space = " ";
            }
            String binValue = Hdl.getConstantVector(i, nrOfSelectBits);
            if (Hdl.isVhdl()) {
                contents.empty().addVhdlKeywords().add("demuxOut_{{1}}{{2}}<= demuxIn {{when}} sel = {{3}} {{and}}", i, space, binValue);
                if (attrs.getValue(StdAttr.WIDTH).getWidth() > 1) {
                    contents.add("                            enable = '1' {{else}} ({{others}} => '0');");
                    continue;
                }
                contents.add("                            enable = '1' {{else}} '0';");
                continue;
            }
            contents.add("assign demuxOut_{{1}}{{2}} = (enable&(sel == {{3}} )) ? demuxIn : 0;", i, space, binValue);
        }
        return contents;
    }
}

