/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.JInputComponent;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;

public class TclComponentAttributes
extends AbstractAttributeSet {
    public static final Attribute<File> CONTENT_FILE_ATTR = new ContentFileAttribute();
    private static final List<Attribute<?>> attributes = Arrays.asList(CONTENT_FILE_ATTR, StdAttr.LABEL, StdAttr.LABEL_FONT);
    private File contentFile;
    private String label = "";
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;

    TclComponentAttributes() {
        this.contentFile = new File(System.getProperty("user.home"));
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        TclComponentAttributes attr = (TclComponentAttributes)dest;
        attr.labelFont = this.labelFont;
        attr.contentFile = new File(this.contentFile.getAbsolutePath());
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return attributes;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == CONTENT_FILE_ATTR) {
            return (V)this.contentFile;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == CONTENT_FILE_ATTR) {
            File newFile = (File)value;
            if (!this.contentFile.equals(newFile)) {
                this.contentFile = newFile;
            }
            this.fireAttributeValueChanged(attr, value, null);
        }
        if (attr == StdAttr.LABEL) {
            String newLabel = (String)value;
            if (this.label.equals(newLabel)) {
                return;
            }
            String oldLabel = this.label;
            this.label = newLabel;
            this.fireAttributeValueChanged(attr, value, oldLabel);
        }
        if (attr == StdAttr.LABEL_FONT) {
            Font newFont = (Font)value;
            if (this.labelFont.equals(newFont)) {
                return;
            }
            this.labelFont = newFont;
            this.fireAttributeValueChanged(attr, value, null);
        }
    }

    private static class ContentFileAttribute
    extends Attribute<File> {
        ContentFileCell chooser;

        public ContentFileAttribute() {
            super("filePath", Strings.S.getter("tclConsoleContentFile"));
        }

        @Override
        public Component getCellEditor(Window source, File file) {
            if (this.chooser == null) {
                this.chooser = new ContentFileCell(file);
            }
            this.chooser.setFileFilter(Loader.TCL_FILTER);
            this.chooser.setFileSelectionMode(0);
            return this.chooser;
        }

        @Override
        public File parse(String path) {
            return new File(path);
        }

        @Override
        public String toDisplayString(File file) {
            if (file.isDirectory()) {
                return "...";
            }
            return file.getName();
        }

        @Override
        public String toStandardString(File file) {
            return file.getPath();
        }
    }

    private static class ContentFileCell
    extends JFileChooser
    implements JInputComponent {
        private static final long serialVersionUID = 1L;

        ContentFileCell(File initial) {
            super(initial);
        }

        @Override
        public Object getValue() {
            return this.getSelectedFile();
        }

        @Override
        public void setValue(Object value) {
            this.setSelectedFile((File)value);
        }
    }
}

