/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.std.ttl.UpDownCounterData;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Ttl74192
extends AbstractTtlGate {
    public static final String _ID = "74192";
    public static final int PORT_INDEX_B = 0;
    public static final int PORT_INDEX_QB = 1;
    public static final int PORT_INDEX_QA = 2;
    public static final int PORT_INDEX_DOWN = 3;
    public static final int PORT_INDEX_UP = 4;
    public static final int PORT_INDEX_QC = 5;
    public static final int PORT_INDEX_QD = 6;
    public static final int PORT_INDEX_D = 7;
    public static final int PORT_INDEX_C = 8;
    public static final int PORT_INDEX_LOAD = 9;
    public static final int PORT_INDEX_CARRY = 10;
    public static final int PORT_INDEX_BORROW = 11;
    public static final int PORT_INDEX_CLEAR = 12;
    public static final int PORT_INDEX_A = 13;
    private static final String[] PORT_NAMES = new String[]{"Data Input B", "Data Output B", "Data Output A", "Count Down", "Count Up", "Data Output C", "Data Output D", "Data Input D", "Data Input C", "Load", "Carry", "Borrow", "Clear", "Data Input A"};
    private static final byte[] OUTPUT_PORTS = new byte[]{2, 3, 6, 7, 12, 13};
    private static final BitWidth WIDTH = BitWidth.create(4);
    private final int maxVal;

    public Ttl74192() {
        this(_ID, 9);
    }

    public Ttl74192(String name, int maxVal) {
        super(name, (byte)16, OUTPUT_PORTS, PORT_NAMES, null);
        super.setInstancePoker(Poker.class);
        this.maxVal = maxVal;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics2D gfx = (Graphics2D)painter.getGraphics();
        super.paintBase(painter, false, false);
        Drawgates.paintPortNames(painter, x, y, height, new String[]{"B", "QB", "QA", "CntD", "CntU", "QC", "QD", "D", "C", "LOAD", "CAR", "BOR", "CLR", "A"});
        UpDownCounterData data = (UpDownCounterData)painter.getData();
        this.drawState(gfx, x, y, height, data);
    }

    private void drawState(Graphics2D gfx, int x, int y, int height, UpDownCounterData state) {
        if (state == null) {
            return;
        }
        Value value = state.getValue();
        for (int i = 0; i < 4; ++i) {
            Value bitValue = value.get(3 - i);
            gfx.setColor(bitValue.getColor());
            gfx.fillOval(x + 52 + i * 10, y + height / 2 - 4, 8, 8);
            gfx.setColor(Color.WHITE);
            GraphicsUtil.drawCenteredText(gfx, bitValue == Value.TRUE ? "1" : "0", x + 56 + i * 10, y + height / 2);
        }
        gfx.setColor(Color.BLACK);
    }

    public static void updateState(InstanceState state, Value value, Value carry, Value borrow, Value down, Value up) {
        UpDownCounterData data = Ttl74192.getStateData(state);
        data.setAll(value, carry, borrow, down, up);
        Value vA = data.getValue().get(0);
        Value vB = data.getValue().get(1);
        Value vC = data.getValue().get(2);
        Value vD = data.getValue().get(3);
        Value vCar = data.getCarry();
        Value vBor = data.getBorrow();
        state.setPort(2, vA, 4);
        state.setPort(1, vB, 4);
        state.setPort(5, vC, 4);
        state.setPort(6, vD, 4);
        state.setPort(10, vCar, 4);
        state.setPort(11, vBor, 4);
    }

    public static UpDownCounterData getStateData(InstanceState state) {
        UpDownCounterData data = (UpDownCounterData)state.getData();
        if (data == null) {
            data = new UpDownCounterData();
            state.setData(data);
        }
        return data;
    }

    @Override
    public void propagateTtl(InstanceState state) {
        boolean upUnchangedHigh;
        UpDownCounterData data = Ttl74192.getStateData(state);
        Value carry = Value.TRUE;
        Value borrow = Value.TRUE;
        long counter = data.getValue().toLongValue();
        Value downPrev = data.getDownPrev();
        Value upPrev = data.getUpPrev();
        Value downCur = state.getPortValue(3);
        Value upCur = state.getPortValue(4);
        boolean downFalling = downPrev == Value.TRUE && downCur == Value.FALSE;
        boolean downRising = downPrev == Value.FALSE && downCur == Value.TRUE;
        boolean upFalling = upPrev == Value.TRUE && upCur == Value.FALSE;
        boolean upRising = upPrev == Value.FALSE && upCur == Value.TRUE;
        boolean downUnchangedHigh = downPrev == Value.TRUE && downCur == Value.TRUE;
        boolean bl = upUnchangedHigh = upPrev == Value.TRUE && upCur == Value.TRUE;
        if (state.getPortValue(12) == Value.TRUE) {
            counter = 0L;
        } else if (state.getPortValue(9) == Value.FALSE) {
            long inputValue = state.getPortValue(13).toLongValue();
            inputValue += state.getPortValue(0).toLongValue() << 1;
            inputValue += state.getPortValue(8).toLongValue() << 2;
            counter = (inputValue += state.getPortValue(7).toLongValue() << 3) > (long)this.maxVal ? 0L : inputValue;
        } else if (downRising && upUnchangedHigh) {
            if (--counter < 0L) {
                counter = this.maxVal;
            }
        } else if (upRising && downUnchangedHigh) {
            if (++counter > (long)this.maxVal) {
                counter = 0L;
            }
        } else if (upFalling && downUnchangedHigh) {
            if (counter == (long)this.maxVal) {
                carry = Value.FALSE;
            }
        } else if (downFalling && upUnchangedHigh) {
            if (counter == 0L) {
                borrow = Value.FALSE;
            }
        } else {
            carry = data.getCarry();
            borrow = data.getBorrow();
        }
        Ttl74192.updateState(state, Value.createKnown(WIDTH, counter), carry, borrow, downCur, upCur);
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            boolean inside = false;
            for (int i = 0; i < 4; ++i) {
                int dx = p.x - (56 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                inside |= d2 < 16;
            }
            return inside;
        }

        private int getIndex(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            for (int i = 0; i < 4; ++i) {
                int dx = p.x - (56 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                if (d2 >= 16) continue;
                return 3 - i;
            }
            return 0;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!state.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
                return;
            }
            if (this.isPressed && this.isInside(state, e)) {
                int index = this.getIndex(state, e);
                UpDownCounterData data = (UpDownCounterData)state.getData();
                if (data == null) {
                    return;
                }
                long current = data.getValue().toLongValue();
                long bitValue = 1L << index;
                Ttl74192.updateState(state, Value.createKnown(WIDTH, current ^= bitValue), Value.FALSE, Value.FALSE, Value.FALSE, Value.FALSE);
            }
            this.isPressed = false;
        }
    }
}

