/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.tools.move.AvoidanceMap;
import com.cburch.logisim.tools.move.ConnectionData;
import com.cburch.logisim.tools.move.ConnectorThread;
import com.cburch.logisim.tools.move.MoveRequest;
import com.cburch.logisim.tools.move.MoveRequestListener;
import com.cburch.logisim.tools.move.MoveResult;
import com.cburch.logisim.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MoveGesture {
    private final MoveRequestListener listener;
    private final Circuit circuit;
    private final HashSet<Component> selected;
    private transient Set<ConnectionData> connections;
    private transient AvoidanceMap initAvoid;
    private final HashMap<MoveRequest, MoveResult> cachedResults;

    public MoveGesture(MoveRequestListener listener, Circuit circuit, Collection<Component> selected) {
        this.listener = listener;
        this.circuit = circuit;
        this.selected = new HashSet<Component>(selected);
        this.connections = null;
        this.initAvoid = null;
        this.cachedResults = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    private static Set<ConnectionData> computeConnections(Circuit circuit, Set<Component> selected) {
        if (CollectionUtil.isNullOrEmpty(selected)) {
            return Collections.emptySet();
        }
        HashSet<Location> locs = new HashSet<Location>();
        for (Component comp : selected) {
            for (EndData end : comp.getEnds()) {
                locs.add(end.getLocation());
            }
        }
        HashSet<ConnectionData> conns = new HashSet<ConnectionData>();
        for (Location loc : locs) {
            void var8_13;
            List<Wire> wirePath;
            boolean found = false;
            for (Component component : circuit.getComponents(loc)) {
                if (selected.contains(component)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            Wire lastOnPath = MoveGesture.findWire(circuit, loc, selected, null);
            if (lastOnPath == null) {
                wirePath = Collections.emptyList();
                Location location = loc;
            } else {
                wirePath = new ArrayList();
                Location cur = loc;
                Wire wire = lastOnPath;
                while (wire != null) {
                    wirePath.add(wire);
                    cur = wire.getOtherEnd(cur);
                    wire = MoveGesture.findWire(circuit, cur, selected, wire);
                }
                Collections.reverse(wirePath);
                Location location = cur;
            }
            Direction dir = null;
            if (lastOnPath != null) {
                Location other = lastOnPath.getOtherEnd(loc);
                int dx = loc.getX() - other.getX();
                int dy = loc.getY() - other.getY();
                dir = Math.abs(dx) > Math.abs(dy) ? (dx > 0 ? Direction.EAST : Direction.WEST) : (dy > 0 ? Direction.SOUTH : Direction.NORTH);
            }
            conns.add(new ConnectionData(loc, dir, wirePath, (Location)var8_13));
        }
        return conns;
    }

    private static Wire findWire(Circuit circ, Location loc, Set<Component> ignore, Wire ignoreWire) {
        Wire ret = null;
        for (Component component : circ.getComponents(loc)) {
            if (ignore.contains(component) || component == ignoreWire) continue;
            if (ret == null && component instanceof Wire) {
                Wire wire;
                ret = wire = (Wire)component;
                continue;
            }
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueRequest(int dx, int dy) {
        MoveRequest request = new MoveRequest(this, dx, dy);
        HashMap<MoveRequest, MoveResult> hashMap = this.cachedResults;
        synchronized (hashMap) {
            MoveResult result = this.cachedResults.get(request);
            if (result == null) {
                ConnectorThread.enqueueRequest(request, false);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoveResult findResult(int dx, int dy) {
        MoveRequest request = new MoveRequest(this, dx, dy);
        HashMap<MoveRequest, MoveResult> hashMap = this.cachedResults;
        synchronized (hashMap) {
            return this.cachedResults.get(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoveResult forceRequest(int dx, int dy) {
        MoveRequest request = new MoveRequest(this, dx, dy);
        ConnectorThread.enqueueRequest(request, true);
        HashMap<MoveRequest, MoveResult> hashMap = this.cachedResults;
        synchronized (hashMap) {
            MoveResult result = this.cachedResults.get(request);
            while (result == null) {
                try {
                    this.cachedResults.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                result = this.cachedResults.get(request);
            }
            return result;
        }
    }

    Set<ConnectionData> getConnections() {
        Set<ConnectionData> ret = this.connections;
        if (ret == null) {
            this.connections = ret = MoveGesture.computeConnections(this.circuit, this.selected);
        }
        return ret;
    }

    AvoidanceMap getFixedAvoidanceMap() {
        AvoidanceMap ret = this.initAvoid;
        if (ret == null) {
            HashSet<Component> comps = new HashSet<Component>(this.circuit.getNonWires());
            comps.addAll(this.circuit.getWires());
            comps.removeAll(this.selected);
            this.initAvoid = ret = AvoidanceMap.create(comps, 0, 0);
        }
        return ret;
    }

    HashSet<Component> getSelected() {
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyResult(MoveRequest request, MoveResult result) {
        HashMap<MoveRequest, MoveResult> hashMap = this.cachedResults;
        synchronized (hashMap) {
            this.cachedResults.put(request, result);
            this.cachedResults.notifyAll();
        }
        if (this.listener != null) {
            this.listener.requestSatisfied(this, request.getDeltaX(), request.getDeltaY());
        }
    }
}

