#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dataframe.h"
#include "column.h"

dataframe* create_dataframe(Enum_Type *dftype, int size){
  list* df = lst_create_list();
  for(int i=0; i< size ; i++){
    Column* col = create_column(dftype[i]);
    lst_insert_tail(df, lst_create_lnode(col));
  }

  return df;
}


void info_dataframe(dataframe* df){
  printf(" .::INFO DATAFRAME::. \n");
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    info_column((Column*)elem->data);
    elem = get_next_node(df, elem);
  }
}


int get_dataframe_lines_size(dataframe* df){
  int size = 0;
  lnode * elem = get_first_node(df);
  if(elem != NULL){
    Column* col =(Column*)elem->data;
    return col->size;
  }
  return 0;
}

int get_dataframe_cols_size(dataframe* df){
  int size = 0;
  lnode * elem = get_first_node(df);
  char str[10];
  while(elem != NULL){
    size++;
    elem = get_next_node(df, elem);
  }
  return size;
}


void print_dataframe_by_index(dataframe* df,
                              unsigned long long int first,
                              unsigned long long int last){
  print_header_dataframe(df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }
  char str[10];
  unsigned long long int size = cols[0]->size; // quicker than use get_dataframe_lines_size
  if (last > size) { last = size; }

  for(unsigned long long int k=first ; k < last ; k++){
    str[0] = '\0';
    for(int l = 0 ; l < size_df ; l++){
      print_value(cols[l], k , str, 10);
      printf("%s \t", str);
    }
    printf("\n");
  }
  free (cols);
}

void print_dataframe(dataframe* df){
  print_dataframe_by_index(df, 0, get_dataframe_lines_size(df));
}


void print_header_dataframe(dataframe* df){
  printf(" .::PRINT DATAFRAME::. \n");
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    Column* col = (Column*)elem->data;
    printf("%s \t", col->column_name);
    elem = get_next_node(df, elem);
  }
  printf("\n");
}

void print_head_dataframe(dataframe* df){
  print_dataframe_by_index(df, 0, 10);
}

void print_tail_dataframe(dataframe* df){
  print_dataframe_by_index(df, get_dataframe_lines_size(df) - 10, get_dataframe_lines_size(df));
}


int insert_line_dataframe(dataframe *df, void * values[], int size){
  if (df == NULL) {return 1;}
  int col_size = get_dataframe_cols_size(df);
  if(col_size != size){
    return 2;
  }
  Column** cols =  (Column**) malloc (sizeof(Column*) * col_size);
  lnode * elem = get_first_node(df);
  int i=0;
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }
  for(i=0 ; i < size ; i++){
    inser_value(cols[i], values[i]);
  }
  free(cols);
  return 0;
}


int set_col_names(dataframe* df, char* tabs[], int size){
  if (df == NULL) {return 1;}
  int col_size = get_dataframe_cols_size(df);
  if(col_size != size){
    return 2;
  }
  Column** cols =  (Column**) malloc (sizeof(Column*) * col_size);
  lnode * elem = get_first_node(df);
  int i=0;
  while(elem != NULL){
    ((Column*)elem->data)->column_name = malloc(sizeof(tabs[i]));
    strcpy(((Column*)elem->data)->column_name, tabs[i]);
    elem = get_next_node(df, elem);
    i++;
  }

}

// demander une fonction qui retour le tableau des types  // idée de Kais Klai
// 

dataframe* load_from_csv(const char* file_name, const Enum_Type  *dftype, int size ){
  dataframe* df;
  FILE *stream;
  char *line = NULL;
  size_t len = 0;
  ssize_t nread;
  char *saveptr1;
  char *token;
  int linenum = 0;
  char ** header = malloc (sizeof(char *) * size);

  Column_Type ** value = (Column_Type **) malloc (sizeof(Column_Type *) * size);
  for (int i=0 ; i < size ; i++){
    value[i] = (Column_Type *) malloc (sizeof(Column_Type));
  }

  stream = fopen(file_name, "r");
  if (stream == NULL) {
    perror("fopen");
    exit(EXIT_FAILURE);
  }

  df = create_dataframe(dftype, size);

  while ((nread = getline(&line, &len, stream)) != -1) {
    char* str = line;
    token = strtok(line, ",");
    int i = 0;
    for (;;){
      if (token == NULL) { // no token read
        // chack if all columns are feels 
        break;
      }

      if (linenum  == 0 ){

        token = strtok(NULL, ",");
        break;
      }

      if(strcmp (token, "NULL") == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "")     == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "null") == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "Null") == 0) { dftype =  NULLVAL;}

      switch(dftype[i]){
      case NULLVAL:
        value[i] = NULL; 
        break;
      case UINT:
      case INT:
      case USHORT:
      case SHORT:
      case ULONG:
      case LONG:
        *((int*)value[i]) = (int)atoi(token);
        break;
      case UCHAR:
      case CHAR:
        *(char*)value[i] = token[0];
        break;
      case FLOAT:
      case DOUBLE:
        *(double*)value[i] = atof(token);
        break;
      case STRING:
        *(char**)value[i] = (char*) malloc (sizeof(char) * (strlen(token) + 1));
        strcpy(*(char**)value[i], token);
        break;
      case OBJECT:
        //*(void*)value[i] = token;
        break;
      };

      token = strtok(NULL, ",");
      i++;
    }
    free(line);
    line = NULL;

    if (linenum  == 0 ){
      linenum++;
      continue;
    }
    insert_line_dataframe(df, value, size);


    
    linenum++;
  }

  for (int i = 0; i< size ; i++){
    free (header[i]);
    free (value[i]);
  }

  free (header);
  free (value);

  fclose(stream);
  return df;
}

