#ifndef _DATAFRAME_H_
#define _DATAFRAME_H_

#include "column.h"
#include "list.h"

typedef list dataframe;

/**
 * Création d'un dataframe 
 */
dataframe* create_dataframe(Enum_Type *dftype, int size);

/**
 * Suppression d'un dataframe
 */
void delete_dataframe(dataframe* df);

/**
 * Suppression d'une colonne en indiquant son nom
 */
void delete_column(dataframe* df, char* col_name);

/**
 * Affichage des informations 
 */
void info_dataframe(dataframe* df);

void print_header_dataframe(dataframe* df);

void print_dataframe_by_index(dataframe* df,
                              unsigned long long int fisrt,
                              unsigned long long int last);

void print_dataframe(dataframe* df);

void print_head_dataframe(dataframe* df);

void print_tail_dataframe(dataframe* df);


int get_dataframe_cols_size(dataframe* df);

int get_dataframe_lines_size(dataframe* df);

int insert_line_dataframe(dataframe* df, void * velues[], int size);

int set_col_names(dataframe* df, char* tabs[], int size);



dataframe* load_from_csv_auto(const char* file_name);

void save_into_csv(dataframe* df, char* file_name);



dataframe* load_from_csv(const char* file_name, const Enum_Type *dftype, int size );

#endif
