#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "column.h"
#include "sort.h"

Column* create_column(Enum_Type type){
  Column* col =  (Column*) malloc (sizeof (Column));
  col->column_name = NULL;
  col->column_type = type;
  col->size = 0;
  col->max_size = 0;
  col->data  = NULL;
  col->index = NULL;
  col->valid_index = 0;
  col->sort_dir = ASC;
  col->index_size = 0;
  return col;
}

int check_value(Enum_Type type, void * value){
  return 1;
}

int inser_value(Column* col, void * value){
  if (check_value(col->column_type, value) == 0){

    return -1;
  }
  check_space_column(col);

  if (value == NULL){
    col->data[col->size] = NULL;
    col->size++;
    return ;
  }

  switch(col->column_type){
  case UINT:
  case INT:
    col->data[col->size] = (int*) malloc (sizeof(int));
    *((int*)col->data[col->size])= *((int*)value);
    break;
  case USHORT:
  case SHORT:
    col->data[col->size] = (short int*) malloc (sizeof(short int));
    *((short int*)col->data[col->size])= *((short int*)value);
    break;
  case ULONG:
  case LONG:
    col->data[col->size] = (long int*) malloc (sizeof(long int));
    *((long int*)col->data[col->size])= *((long int*)value);
    break;
  case UCHAR:
  case CHAR:
    col->data[col->size] = (char*) malloc (sizeof(char));
    *((char*)col->data[col->size])= *((char*)value);
    break;
  case FLOAT:
    col->data[col->size] = (float*) malloc (sizeof(float));
    *((float*)col->data[col->size])= *((float*)value);
    break;
  case DOUBLE:
    col->data[col->size] = (double*) malloc (sizeof(double));
    *((float*)col->data[col->size])= *((double*)value);
    break;
  case STRING:
    char* ptr_str_value = (char*) malloc (sizeof(char) * strlen(*(char**)value) + 1);
    strcpy(ptr_str_value, *(char**)value);
    col->data[col->size] = ptr_str_value;
    break;
  case OBJECT:
    break;
  };
  col->size++;

  // a chaque insertion on invalide l'index 
  if(col->index != 0){
    col->index = -1;
  }
}


int check_space_column(Column* col){
  // first memory allocation
  if (col->max_size == 0){
    col->data = (Column_Type**) malloc(sizeof(Column_Type*) * REALOC_SIZE);
    col->max_size = REALOC_SIZE;
    return 0;
  }
  long long int free_space = col->max_size - col->size;
  if (free_space == 0){
    col->data = (Column_Type**) realloc (col->data, sizeof(Column_Type*) * col->max_size);
    col->max_size = col->max_size + REALOC_SIZE ;
  }
}


void print_value(Column* col, unsigned long long int i, char* str, int size){

  if (col->data[i] == NULL){
    snprintf(str, size, "%s", "NULL");
    return;
  }

  switch(col->column_type){
  case UINT:
  case INT:
    snprintf(str, size, "%d", *((int*)col->data[i]));
    break;
  case USHORT:
  case SHORT:
    snprintf(str, size, "%d", *((short*)col->data[i]));
    break;
  case ULONG:
  case LONG:
    snprintf(str, size, "%d", *((long*)col->data[i]));
    break;
  case UCHAR:
  case CHAR:
    snprintf(str, size, "%c", *((char*)col->data[i]));
    break;
  case FLOAT:
    snprintf(str, size, "%f10.2", *((float*)col->data[i]));
    break;
  case DOUBLE:
    snprintf(str, size, "%f10.2", *((double*)col->data[i]));
    break;
  case STRING:
    snprintf(str, size, "%s", ((char*)col->data[i]));
    break;
  case OBJECT:
    snprintf(str, size, "Object");
    break;
  };
}


void print_col(Column* col){
  char str[10];
  for(int i=0 ; i < col->size ; i++){
    print_value(col, i, str, 10);
    printf("[%d] %s \n", i, str);
  }
  printf("\n");
}


void print_col_by_index(Column* col){
  if (col->valid_index == 0){
    printf("No index \n");
    return;
  }
  char str[10];
  for(int i=0 ; i < col->size ; i++){
    print_value(col, col->index[i], str, 10);
    printf("[%d] %s \n", i, str);
  }
  printf("\n");
}


void print_col_index(Column* col){
  if (col->valid_index != 1){
    return;
  }
  char str[10];
  for(int i=0 ; i < col->size ; i++){
    print_value(col, i, str, 10);
    printf("[%d] %s \n", col->index[i], str);
  }
  printf("\n");
}


void info_column(Column* col){
  char* col_types[] =  {"", "NULLVAL", "UINT", "INT", "USHORT", "SHORT", "ULONG",
                  "LONG", "UCHAR", "CHAR", "FLOAT", "DOUBLE", "STRING", "OBJECT" };

  printf("-type %s \n", col->column_name);
  printf("  type %s \n", col_types[col->column_type]);
  printf("  size %d \n", col->size);
}


void extend_index(Column* col){
  if (col->valid_index == 0){
    col->index = (int*) malloc (sizeof(int) * col->size);
  }
  // realloc and put new numbers 
  col->index = (int*) realloc (col->index , sizeof(int) * col->size);

  for(int i=col->index_size ; i < col->size ; i++){
    col->index[i] = i;
  }
  col->index_size = col->size;
  col->valid_index = -1;
}

void create_index(Column* col){
  if (col->valid_index == 0){
    col->index = (int*) malloc (sizeof(unsigned long long int) * col->size);
  }
  for(int i=0 ; i < col->size ; i++){
    col->index[i] = i;
  }
  col->index_size = col->size;
}

void erase_index(Column* col){
  if (col->valid_index != 0){
    free(col->index);
    col->index = NULL;
    col->index_size = 0;
  }
  col->valid_index = 0;
}


int check_index(Column* col){
  return col->valid_index;
};


int update_index(Column* col){
  sort(col, col->sort_dir);
};


void sort(Column* col, int sort_dir){
  if (col->sort_dir != sort_dir){
    erase_index(col);
  }

  if (col->valid_index == 1){ // deja trié
    return;
  }
  if (col->valid_index == 0){  // non trié / pas d'index
    create_index(col);
  }
  if (col->valid_index == -1){  // partiellement trié
    extend_index(col);
  }
  col->sort_dir = sort_dir;

  if(col->valid_index == -1){
    // /!\ attention il faut ajouter le sens de tri 
    insertion_sort(col);  // si partiellement trié alors tri par insertion
  }
  else{
    // /!\ attention il faut ajouter le sens de tri 
    quick_sort(col, &pivot_middle); // tri rapide sinon
  }

  col->valid_index = 1;
  col->sort_dir = sort_dir;
}




Column*
applay_function_column(Column* col_1,
                       Column*  col_2,
                       Enum_Type dftype,
                       void *(*fct)(void *,void*))
{
  Column* new_col  = create_column(dftype);
  for(unsigned long long int i=0 ; i < col_1->size ; i++)
    {
      int value = (int)fct(col_1->data[i], col_2->data[i]);
      int *v = &value;
      inser_value(new_col, v);
    }
  return new_col;
}

Column_Type*
applay_function_column_linue(Column* col, void *(*fct)(void *,void*))
{
  int sum;
  Column_Type* res = (Column_Type*) malloc (sizeof(Column_Type));

  if(col->size == 0){
    sum = 0;
    res = (Column_Type*)(&sum);
    return res;
  }
  res = (int) col->data[0];
  for(unsigned long long int i=0 ; i < col->size - 1 ; i++){
    sum = (int)fct(sum, col->data[i]);
  }

  return &res;
}
