#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dataframe.h"
#include "column.h"

dataframe* create_dataframe(Enum_Type *dftype, int size){
  list* df = lst_create_list();
  for(int i=0; i< size ; i++){
    Column* col = create_column(dftype[i]);
    lst_insert_tail(df, lst_create_lnode(col));
  }

  return df;
}


void info_dataframe(dataframe* df){
  printf(" .::INFO DATAFRAME::. \n");
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    info_column((Column*)elem->data);
    elem = get_next_node(df, elem);
  }
}


int get_dataframe_lines_size(dataframe* df){
  int size = 0;
  lnode * elem = get_first_node(df);
  if(elem != NULL){
    Column* col =(Column*)elem->data;
    return col->size;
  }
  return 0;
}

int get_dataframe_cols_size(dataframe* df){
  int size = 0;
  lnode * elem = get_first_node(df);
  char str[10];
  while(elem != NULL){
    size++;
    elem = get_next_node(df, elem);
  }
  return size;
}


void print_dataframe_by_line(dataframe* df,
                              unsigned long long int first,
                              unsigned long long int last){
  print_header_dataframe(df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }
  char str[10];
  unsigned long long int size = cols[0]->size; // quicker than use get_dataframe_lines_size
  if (last > size) { last = size; }

  for(unsigned long long int k=first ; k < last ; k++){
    str[0] = '\0';
    for(int l = 0 ; l < size_df ; l++){
      print_value(cols[l], k , str, 10);
      printf("%s \t", str);
    }
    printf("\n");
  }
  free (cols);
}

void print_dataframe(dataframe* df){
  print_dataframe_by_line(df, 0, get_dataframe_lines_size(df));
}


void print_header_dataframe(dataframe* df){
  printf(" .::PRINT DATAFRAME::. \n");
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    Column* col = (Column*)elem->data;
    printf("%s \t", col->column_name);
    elem = get_next_node(df, elem);
  }
  printf("\n");
}

void print_head_dataframe(dataframe* df){
  print_dataframe_by_line(df, 0, 10);
}

void print_tail_dataframe(dataframe* df){
  print_dataframe_by_line(df, get_dataframe_lines_size(df) - 10, get_dataframe_lines_size(df));
}


int insert_line_dataframe(dataframe *df, void * values[], int size){
  if (df == NULL) {return 1;}
  int col_size = get_dataframe_cols_size(df);
  if(col_size != size){
    return 2;
  }
  Column** cols =  (Column**) malloc (sizeof(Column*) * col_size);
  lnode * elem = get_first_node(df);
  int i=0;
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }
  for(i=0 ; i < size ; i++){
    inser_value(cols[i], values[i]);
  }
  free(cols);
  return 0;
}


int set_col_names(dataframe* df, char* tabs[], int size){
  if (df == NULL) {return 1;}
  int col_size = get_dataframe_cols_size(df);
  if(col_size != size){
    return 2;
  }
  Column** cols =  (Column**) malloc (sizeof(Column*) * col_size);
  lnode * elem = get_first_node(df);
  int i=0;
  while(elem != NULL){
    ((Column*)elem->data)->column_name = malloc(sizeof(tabs[i]));
    strcpy(((Column*)elem->data)->column_name, tabs[i]);
    elem = get_next_node(df, elem);
    i++;
  }

}

// demander une fonction qui retour le tableau des types  // idée de Kais Klai
// 

dataframe* load_from_csv(const char* file_name, const Enum_Type  *dftype, int size ){
  dataframe* df;
  FILE *stream;
  char *line = NULL;
  size_t len = 0;
  ssize_t nread;
  char *saveptr1;
  char *token;
  int linenum = 0;
  char ** header = malloc (sizeof(char *) * size);

  Column_Type ** value = (Column_Type **) malloc (sizeof(Column_Type *) * size);
  for (int i=0 ; i < size ; i++){
    value[i] = (Column_Type *) malloc (sizeof(Column_Type));
  }

  stream = fopen(file_name, "r");
  if (stream == NULL) {
    perror("fopen");
    exit(EXIT_FAILURE);
  }

  df = create_dataframe(dftype, size);

  while ((nread = getline(&line, &len, stream)) != -1) {
    char* str = line;
    token = strtok(line, ",");
    int i = 0;
    for (;;){
      if (token == NULL) { // no token read
        // chack if all columns are feels 
        break;
      }

      if (linenum  == 0 ){

        token = strtok(NULL, ",");
        break;
      }

      if(strcmp (token, "NULL") == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "")     == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "null") == 0) { dftype =  NULLVAL;}
      if(strcmp (token, "Null") == 0) { dftype =  NULLVAL;}

      switch(dftype[i]){
      case NULLVAL:
        value[i] = NULL; 
        break;
      case UINT:
      case INT:
      case USHORT:
      case SHORT:
      case ULONG:
      case LONG:
        *((int*)value[i]) = (int)atoi(token);
        break;
      case UCHAR:
      case CHAR:
        *(char*)value[i] = token[0];
        break;
      case FLOAT:
        *((float*)value[i]) = atof(token);
        break;
      case DOUBLE:
        *((double*)value[i]) = atof(token);
        break;
      case STRING:
        *(char**)value[i] = (char*) malloc (sizeof(char) * (strlen(token) + 1));
        strcpy(*(char**)value[i], token);
        break;
      case OBJECT:
        //*(void*)value[i] = token;
        break;
      };

      token = strtok(NULL, ",");
      i++;
    }
    free(line);
    line = NULL;

    if (linenum  == 0 ){
      linenum++;
      continue;
    }
    insert_line_dataframe(df, value, size);
    linenum++;
  }

  for (int i = 0; i< size ; i++){
    free (header[i]);
    free (value[i]);
  }

  free (header);
  free (value);

  fclose(stream);
  return df;
}


void save_into_csv(dataframe* df, const char* file_name){
  FILE* file_desc = fopen(file_name, "w");
  print_header_dataframe (df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }
  char str[10];
  unsigned long long int first = 0;
  unsigned long long int last  = get_dataframe_lines_size(df);
  unsigned long long int size = cols[0]->size; // quicker than use get_dataframe_lines_size
  if (last > size) { last = size; }
  for(unsigned long long int k=first ; k < last ; k++){
    str[0] = '\0';
    for(int l = 0 ; l < size_df ; l++){
      print_value(cols[l], k , str, 10);
      fprintf(file_desc, "%s", str);
      if(l != size_df - 1){
        fprintf(file_desc, ",");
      }
    }
    fprintf(file_desc, "\n");
  }
  free (cols);
  fclose(file_desc);
}


int sort_dataframe(dataframe* df, const unsigned int num_col, char sort_dir){
  int col_size = get_dataframe_cols_size(df);
  if(num_col >= col_size) { return -1; }

  Column** cols =  (Column**) malloc (sizeof(Column*) * col_size);
  lnode * elem = get_first_node(df);
  int i=0;
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }

  sort(cols[num_col], sort_dir);
  free(cols);
}




void print_sort_dataframe_by_line(dataframe* df,
                                  unsigned long long int first,
                                  unsigned long long int last,
                                  int col_num){


  print_header_dataframe(df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }

  if(cols[col_num]->valid_index != 1){
    return -1;
  }

  char str[10];
  unsigned long long int size = cols[0]->size; // quicker than use get_dataframe_lines_size
  if (last > size) { last = size; }

  for(unsigned long long int k= first ; k < last ; k++){

    unsigned long long int num_line = cols[col_num]->index[k]; 

    str[0] = '\0';
    for(int l = 0 ; l < size_df ; l++){
      print_value(cols[l], num_line , str, 10);
      printf("%s \t", str);
    }
    printf("\n");
  }
  free (cols);

}

void print_sort_dataframe(dataframe* df, int col_num){
  print_sort_dataframe_by_line(df, 0, get_dataframe_lines_size(df),col_num);
}

void print_head_sort_dataframe(dataframe* df, int col_num){
  print_sort_dataframe_by_line(df, 0, 10,col_num);
}

void print_tail_sort_dataframe(dataframe* df, int col_num){
  print_sort_dataframe_by_line(df, get_dataframe_lines_size(df) - 10, get_dataframe_lines_size(df), col_num);
}

void print_column_sort_dataframe(dataframe* df, int col_num){
  print_header_dataframe(df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }

  if(cols[col_num]->valid_index != 1){
    return -1;
  }
  print_col_by_index(cols[col_num]);

  free(cols);
}

void print_column_dataframe(dataframe* df, int col_num){
  print_header_dataframe(df);
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL){
    cols[i++] = (Column*)elem->data;
    elem = get_next_node(df, elem);
  }

  print_col(cols[col_num]);

  free(cols);
}

void
applay_function_line_df(dataframe* df,
                   int col_1,
                   int col_2,
                   Enum_Type dftype,
                   void *(*fct)(void *,void*))
{
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL)
    {
      cols[i++] = (Column*)elem->data;
      elem = get_next_node(df, elem);
    }
  Column* new_col =   applay_function_column(cols[col_1], cols[col_2], dftype, fct);
  lst_insert_tail(df, lst_create_lnode(new_col));
  free(cols);
}


Column_Type*
applay_function_column_df(dataframe* df,
                          int col,
                          void *(*fct)(void *,void*))
{
  int size_df = get_dataframe_cols_size(df);
  if (size_df == 0){return;}
  Column** cols =  (Column**) malloc (sizeof(Column*) * size_df);
  int i = 0;
  lnode * elem = get_first_node(df);
  while(elem != NULL)
    {
      cols[i++] = (Column*)elem->data;
      elem = get_next_node(df, elem);
    }
  Column_Type* res =  applay_function_column_linue(cols[col], fct);
  free(cols);
  return res;
}
